<?php

$title_width = get_post_meta(get_the_ID(), 'edgtf_portfolio_single_title_width_meta', true);
$title_override_meta = get_post_meta(get_the_ID(), 'edgtf_portfolio_single_title_text_override_meta', true);
$title_override_additional_meta = get_post_meta(get_the_ID(), 'edgtf_portfolio_single_additional_title_text_meta', true);

$title_override = !empty($title_override_meta) ? $title_override_meta : '';
$title_override_additional = !empty($title_override_additional_meta) ? $title_override_additional_meta : '';

$title_style = array();

if ($title_width !== '') {
    $title_style[] = 'width: ' . $title_width . '%';
}


?>

<div class="edgtf-ps-info-item edgtf-ps-content-item">


    <h3 class="edgtf-portfolio-title" <?php haar_edge_inline_style($title_style); ?>>
        <?php if(empty($title_override) && empty($title_override_additional)) { ?>
            <span class="edgtf-portfolio-inner-title"><?php the_title(); ?></span>
        <?php } ?>
        <?php if(!empty($title_override)) { ?>
            <span class="edgtf-portfolio-inner-title-override"><?php echo esc_html($title_override); ?></span>
        <?php } ?>
        <?php if(!empty($title_override_additional)) { ?>
            <span class="edgtf-portfolio-additional-title"><?php echo esc_html($title_override_additional); ?></span>
        <?php } ?>
    </h3>
</div>